/*	gensktab.c	1.4	83/05/13	*/
#include <stdio.h>
#include "cpmio.h"

/*
 * Generate a skew factor table in skewtab according to the
 * global parameters given by skew and sectrk.
 * This routine must be called before any disk (or virtual disk)
 * accesses are attempted.
 */

int
cpm_gen_sktab(struct cpmfs *cpmfs)
{
	int	*i, *j;
	char	*malloc();

	if (( cpmfs->skewtab = (int *) malloc(cpmfs->sectrk*4)) == NULL) {
	    return(FALSE);	/* no more memory	*/
	}
	*cpmfs->skewtab = 1;
	for (i=cpmfs->skewtab+1; i<cpmfs->skewtab+ cpmfs->sectrk; i++) {
		*i = *(i-1) + cpmfs->skew;
		if (*i > cpmfs->sectrk) {
			*i -= cpmfs->sectrk;
L1:
			for (j=cpmfs->skewtab; j<i; j++) {
				if (*j == *i) 
					break;
			}
			if (j < i ) { 
				++*i; 
				goto L1; 
			}
		}
	}

	return(TRUE);
}
